
IF EXISTS
(
    SELECT *
    FROM sys.indexes
    WHERE name = 'PK_PDV_VD_PDV_VD_NFCE'
          AND object_id = OBJECT_ID('PDV_VD_PDV_VD_NFCE')
)
    BEGIN
        ALTER TABLE PDV_VD_PDV_VD_NFCE DROP CONSTRAINT PK_PDV_VD_PDV_VD_NFCE;
    END;
GO
WITH TABELA
     AS (SELECT ROW_NUMBER() OVER(PARTITION BY CD_EMP,
                                               CD_FILIAL,
                                               CD_VD,
                                               CD_NFCE 
						    ORDER BY CD_EMP,
                                           CD_FILIAL,
                                           CD_VD,
                                           CD_NFCE) RN,
                CD_EMP,
                CD_FILIAL,
                CD_VD,
                CD_NFCE
         FROM PDV_VD_PDV_VD_NFCE)
     DELETE FROM TABELA
     WHERE RN > 1;
GO
ALTER TABLE PDV_VD_PDV_VD_NFCE
ADD CONSTRAINT PK_PDV_VD_PDV_VD_NFCE PRIMARY KEY(CD_EMP, CD_FILIAL, CD_VD, CD_NFCE);